/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.workflowstab;

import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMArrivalsTab;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMDesignerWorkflowPane;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMStepPropertiesTab;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.event.IVWMapChangedListener;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.utils.event.IVWToolbarActionListener;
import filenet.vw.toolkit.utils.event.VWToolbarActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemListener;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

class VWSIMWorkflowPropertiesPanel
extends JPanel
implements IVWMapChangedListener,
IVWToolbarActionListener {
    private VWToolbarBorder m_titleBorder = null;
    private JTabbedPane m_tabs = null;
    private VWSIMStepPropertiesTab m_stepTab = null;
    private VWSIMArrivalsTab m_arrivalsTab = null;
    private VWSIMPropertyData m_propertyData = null;
    private VWSIMDesignerWorkflowPane m_mapPane = null;

    public void init(VWSIMPropertyData propertyData, VWSIMDesignerWorkflowPane mapPane) {
        this.m_propertyData = propertyData;
        this.m_mapPane = mapPane;
        this.setLayout(new BorderLayout());
        this.initTabControls();
        this.m_propertyData.getMapChangeEventNotifier().addMapChangedListener(this);
        this.m_propertyData.getToolbarActionNotifier().addToolbarActionListener(this);
    }

    public ItemListener getListener() {
        return this.m_stepTab;
    }

    public void releaseReferences() {
        this.m_titleBorder = null;
        this.m_tabs = null;
        this.m_stepTab = null;
        this.m_arrivalsTab = null;
        this.m_propertyData = null;
        this.m_mapPane = null;
    }

    public void mapChanged(VWMapChangedEvent event) {
        switch (event.getID()) {
            case 554: {
                if (this.m_tabs != null) {
                    this.m_tabs.setSelectedIndex(0);
                }
                this.reinitialize("Workflow");
            }
        }
    }

    public void toolbarActionPerformed(VWToolbarActionEvent event) {
        switch (event.getID()) {
            case 502: {
                this.reinitialize((String)event.getParam());
            }
        }
    }

    private void initTabControls() {
        this.m_tabs = new JTabbedPane();
        this.m_tabs.setTabPlacement(1);
        this.m_arrivalsTab = new VWSIMArrivalsTab();
        this.m_arrivalsTab.init(this.m_propertyData);
        this.m_tabs.addTab(VWSIMResource.s_arrivals, this.m_arrivalsTab);
        this.m_stepTab = new VWSIMStepPropertiesTab();
        this.m_stepTab.init(this.m_propertyData, this.m_mapPane);
        this.m_tabs.addTab(VWSIMResource.s_step, this.m_stepTab);
        this.add((Component)this.m_tabs, "Center");
    }

    private void reinitialize(String mapName) {
        try {
            VWWorkflowDefinition wfDef = this.m_propertyData.getSelectedWorkflowDefinition();
            if (wfDef != null) {
                this.m_arrivalsTab.changeWorkflow(wfDef.getName());
                this.m_stepTab.changeMap(mapName == null ? "Workflow" : mapName);
            } else {
                this.m_mapPane.setWorkflowDefinition(null, null);
                this.m_arrivalsTab.changeWorkflow(null);
                this.m_stepTab.reinitialize(null, null, false);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

